'use strict';

var streak = require('longest-streak');
var repeat = require('repeat-string');

module.exports = inlineCode;

/* Stringify inline code.
 *
 * Knows about internal ticks (`\``), and ensures one more
 * tick is used to enclose the inline code:
 *
 *     ```foo ``bar`` baz```
 *
 * Even knows about inital and final ticks:
 *
 *     `` `foo ``
 *     `` foo` ``
 */
function inlineCode(node) {
  var value = node.value;
  var ticks = repeat('`', streak(value, '`') + 1);
  var start = ticks;
  var end = ticks;

  if (value.charAt(0) === '`') {
    start += ' ';
  }

  if (value.charAt(value.length - 1) === '`') {
    end = ' ' + end;
  }

  return start + value + end;
}
