"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = _stylelint.utils.validateOptions(result, ruleName, {
      actual: expectation,
      possible: ["always-last-in-chain"]
    });
    if (!validOptions) {
      return;
    }

    (0, _atIfClosingBraceNewlineAfter.sassConditionalBraceNLAfterChecker)({
      root: root,
      result: result,
      ruleName: ruleName,
      atRuleName: "else",
      expectation: expectation,
      messages: messages
    });
  };
};

var _utils = require("../../utils");

var _stylelint = require("stylelint");

var _atIfClosingBraceNewlineAfter = require("../at-if-closing-brace-newline-after");

var ruleName = exports.ruleName = (0, _utils.namespace)("at-else-closing-brace-newline-after");

var messages = exports.messages = _stylelint.utils.ruleMessages(ruleName, {
  expected: 'Expected newline after "}" of @else statement',
  rejected: 'Unexpected newline after "}" of @else statement'
});