// Generated by CoffeeScript 1.8.0
var jsonBodyParser, parseBodyAsJSON;

jsonBodyParser = function() {
  return function(request, response, next) {
    return parseBodyAsJSON(request, response, next);
  };
};

parseBodyAsJSON = function(request, response, next) {
  var buffer;
  if (request.body) {
    return next();
  }
  request.body = {};
  if (request.method !== 'POST') {
    return next();
  }
  request.setEncoding('utf8');
  buffer = '';
  request.on('data', function(chunk) {
    return buffer += chunk;
  });
  return request.on('end', function() {
    var e;
    if ('' === buffer) {
      return next();
    }
    try {
      request.body = JSON.parse(buffer);
      return next();
    } catch (_error) {
      e = _error;
      return next(e);
    }
  });
};

module.exports = jsonBodyParser;
