@extends('views.layouts.main')

@section('content')
<div class="visual-image">
@if(get_post_thumbnail_id(get_the_id()))
        <img class="visual-image__img" src="{{ wp_get_attachment_url( get_post_thumbnail_id(get_the_id())) }}" alt="main-feature-image">
 @endif
      </div>
<main class="main">
      <div class="main-area container">
        <div class="main-frame">
        <div class="breadcrumb" style="margin-top: 10px;">{{bcn_display()}}</div>
          <div class="row text-area">
            <div class="col-lg-6">
              <div class="text-frame">
                @while (have_posts()) @php the_post() @endphp
                {!!the_content()!!}
                @endwhile
                </div>
            </div>
            <div class="col-lg-6">
              <div class="about-image">
                <img class="about-image__img" src="{{get_field('about_large_image')}}" alt="about_large_image">
                <div class="about-image__sub-img">
                  <img src="{{get_field('about_image')}}" alt="about_image">
                </div>
              </div>
            </div>
          </div>
          @if(get_field('section_2_title'))
          <h2 class="main-frame__heading">{{the_field('section_2_title')}}</h2>
          @endif
          <div class="row text-area">
            <div class="col-lg-6">
              @if(get_field('about_left_content'))
                <div class="text-frame">
                {{the_field('about_left_content')}}
                </div>
              @endif
            </div>
            <div class="col-lg-6">
              @if(get_field('about_right_content'))
              <div class="text-frame">
              {{the_field('about_right_content')}}
              </div>
              @endif
            </div>
          </div>
        </div>
        @if(get_field('section_3_image') && get_field('section_3_content'))
        <div class="manufacturing-area">
          <div class="row">
            <div class="col-lg-6 col-md-12">
              <div class="manufacturing-area__image-holder">
              @if(get_field('section_3_image'))
                <img class="manufacturing-area__img" src="{{get_field('section_3_image')}}" alt="section_3_image">
              @endif
              </div>
            </div>
            <div class="col-lg-6 col-md-12">
              @if(get_field('section_3_content'))
                <div class="manufacturing-description">
                {{the_field('section_3_content')}}
                </div>
              @endif
            </div>
          </div>
        </div>
        @endif
        <div class="history-area">
        @if(get_field('section_4_content'))
          <div class="history-heading">
          {{the_field('section_4_content')}}
          @if(get_field('button_url'))
          <a href="{{get_field('button_url')}}" class="btn btn-primary">{{get_field('button_text')}}</a>
          @endif
          </div>
          @endif
          <div class="history-holder row">
          @foreach(get_field('boxes') as $row)
          <div class="col-lg-4 col-md-6 col-sm-6">
              <div class="history-block">
                <a href="{{$row['box_url']}}" class="history-block__link">
                  <div class="history-block__image-holder">
                    <img class="history-block__img" src="{{$row['image']}}" alt="{{$row['box_text']}}">
                  </div>
                  <span class="btn btn-primary">{{$row['box_text']}} <i class="icon-right-arrow"></i></span>
                </a>
              </div>
            </div>
            @endforeach
            </div>
        </div>
      </div>
    </main>
@endsection
