@extends('views.layouts.main')

@section('content')
<div class="visual-image style01">
          <img class="visual-image__img" src="{{ wp_get_attachment_url( get_post_thumbnail_id(get_the_id())) }}" alt="main-feature-image">
        </div>
    <main class="main">
      <div class="main-area container">
        <div class="row">
          <div class="col-lg-8 col-md-12">
            <div class="contact-area">
            <div class="breadcrumb">{{bcn_display()}}</div>
                <div class="heading-holder">
                  <h1 class="heading-holder__heading">{{the_title()}}</h1>
                </div>
                <div class="content_area">
                    @while (have_posts()) @php the_post() @endphp
                    {!!the_content()!!}
                    @endwhile
                </div>
            </div>
          </div>
          <div class="col-lg-4 col-md-12">
            <aside class="sidebar">
              <div class="sidebar-holder">
                <h2 class="sidebar__heading">{{get_field('sidebar_title')}}</h2>
                <strong class="sidebar__title">{{get_field('sidebar_sub_title')}}</strong>
                <ul class="contact-list list-unstyled mb-0">
                  <li class="contact-list__item">
                    <a target="_blank" href="{{get_field('address_url')}}" class="contact-list__link">
                      <i class="contact-list__icon icon-pin"></i>
                      {{get_field('address')}}
                    </a>
                  </li>
                  <li class="contact-list__item">
                    <a href="mailto:{{get_field('email')}}" class="contact-list__link">
                      <i class="contact-list__icon icon-mail"></i>
                      {{get_field('email')}}
                    </a>
                  </li>
                  <li class="contact-list__item">
                    <a href="tel:{{get_field('phone_number')}}" class="contact-list__link">
                      <i class="contact-list__icon icon-call"></i>
                      Phone: {{get_field('phone_number')}}
                    </a>
                  </li>
                  <li class="contact-list__item">
                    <a href="tel:2153879043" class="contact-list__link">
                      <i class="contact-list__icon icon-fax"></i>
                      Fax: {{get_field('fax')}}
                    </a>
                  </li>
                </ul>
              </div>
              <div class="social-area">
                <ul class="social-networks mb-0 list-unstyled">
                  <li class="social-networks__text"><a target="_blank" href="{{ get_field('facebook_link', 'options') }}" class="social-networks__link-box"><i class="social-networks__icon icon-facebook"></i></a></li>
                  <li class="social-networks__text"><a target="_blank" href="{{ get_field('twitter_link', 'options') }}" class="social-networks__link-box"><i class="social-networks__icon icon-twitter"></i></a></li>
                  <li class="social-networks__text"><a target="_blank" href="{{ get_field('linkedin_link', 'options') }}" class="social-networks__link-box"><i class="social-networks__icon icon-linkedin"></i></a></li>
                </ul>
              </div>
            </aside>
          </div>
        </div>
      </div>
    </main>
@endsection
