@extends('views.layouts.main')

@section('content')
<div id="carouselExampleControls" class="carousel slide" data-ride="carousel" data-interval="4000">
        <div class="carousel-inner">
        @php ($count = 1)
          @foreach(get_field('slider') as $row)
                <div class="carousel-item @if ($count === 1) active @endif">
                    <img class="d-block" src="{{$row['slider_image']}}" alt="slider_image">
                    <div class="caption-area">
                    <div class="caption-holder container">
                        <div class="caption">
                        {!!$row['slider_content']!!}
                        </div>
                    </div>
                    </div>
                </div>
            @php ($count++)
        @endforeach
        </div>
        <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev"><i class="icon-arrow-left"></i></a>
        <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next"><i class="icon-arrow-right2"></i></a>
      </div>
    <main class="main home-main">
      <div class="product-area container">
        <div class="product-holder">
          <div class="block-heading">
            <div class="block-number">
              <span class="block-number__number"></span>
              <span class="icon-right-bottom"></span>
            </div>
            {!!get_field('products_section')!!}
        </div>
          <div class="product-frame row">
            @foreach(get_field('products') as $row)
                <div class="col-lg-3 col-md-4 col-sm-6">
                    <div class="product-block">
                        <a href="{!!$row['url']!!}" class="product-block__link">
                        <div class="product-block__image-holder">
                            <img class="product-block__img" src="{!!$row['image']!!}" alt="{!!$row['title']!!}">
                        </div>
                        <span class="btn btn-primary">{!!$row['title']!!} <i class="icon-right-arrow"></i></span>
                        </a>
                    </div>
                </div>
             @endforeach
          </div>
        </div>
      </div>
      <div class="news-blocks">
        <div class="container">
          <h2>News <a href="/news/">View All</a></h2>
          <div class="holder row">
            <?php
            $args = array('post_type'=> 'news', 'post_status' => 'publish', 'orderby' => 'date','posts_per_page' => '3');
      $query = new WP_Query($args);
      while($query->have_posts()) : $query->the_post(); ?>
                    <div class="col-md-4">
                      <a href="<?php echo get_the_permalink(); ?>"> 
                        <div class="image">
                          <?php 
              if ( has_post_thumbnail() ) {
                 the_post_thumbnail(array(155,100));
              } 
              ?>
                        </div>
                        <div class="description">
                          <span><?php the_title(); ?> <i>>></i></span>
                        </div>
                      </a>
                    </div>                    
                <?php
                endwhile; 
                wp_reset_query();      
            ?>
          </div>
        </div>
      </div>
      <div class="quality-area">
        <div class="container">
          <div class="quality-holder">
            <div class="block-number">
              <span class="block-number__number"></span>
              <span class="icon-right-bottom"></span>
            </div>
            {!!get_field('section2')!!}
            <a href="{!!get_field('learn_more_link')!!}" class="btn btn-secondary">Learn more</a>
          </div>
        </div>
      </div>
      <div class="features-area">
        <div class="container">
          <div class="block-number">
            <span class="block-number__number"></span>
            <span class="icon-right-bottom"></span>
          </div>
          <h2 class="features-area__heading1">{!!get_field('section_3_title')!!}</h2>
          <div class="features-holder">
            <div class="list-info">
            @foreach(get_field('section_3_content_left') as $row)
                <div class="list-info__holder">
                    <p class="mb-0"><i class="list-info__icon"></i>{!!$row['content']!!}</p>
                </div>
             @endforeach
            </div>
            <div class="features-area__features-image">
              <img class="features-area__img" src="{{get_field('section_3_image')}}" alt="section_3_image">
            </div>
            <div class="list-info style01">
            @foreach(get_field('section_3_content_right') as $row)
                <div class="list-info__holder">
                    <p class="mb-0"><i class="list-info__icon"></i>{!!$row['content']!!}</p>
                </div>
             @endforeach
            </div>
          </div>
        </div>
      </div>
      <div class="industries-area">
        <div class="container">
          <div class="block-heading">
            <div class="block-number">
              <span class="block-number__number"></span>
              <span class="icon-right-bottom"></span>
            </div>
            {!!get_field('section4_industries')!!}
          </div>
          <div class="industries-holder row">
          @foreach(get_field('industries') as $row)
            <div class="col-md-4 col-sm-6">
                <div class="industries-block">
                    <a href="{!!$row['url']!!}" class="industries-block__link">
                    <div class="industries-block__image-holder">
                    <img class="industries-block__img" src="{{$row['image']}}" alt="{{$row['title']}}">
                    </div>
                    <span class="btn btn-primary">{!!$row['title']!!} <i class="icon-right-arrow"></i></span>
                    </a>
                </div>
            </div>
             @endforeach
          </div>
        </div>
      </div>
      <div class="spec-area">
        <div class="container">
          <div class="spec-holder">
            <div class="block-number">
              <span class="block-number__number"></span>
              <span class="icon-right-bottom"></span>
            </div>
            <div class="row">
              <div class="spec-area__col col-lg-6 order-lg-2">
                  <div class="spec-description">
                    {!! get_field('section_5_content') !!}
                  </div>
                  <?php if (!is_user_logged_in()) {
    ?>
                  <a href="javascript:void(0)" class="btn btn-secondary login_modal">Sign UP</a>
                  <?php
} else {
        ?>
                    <a href="{{get_field('sing_up_url')}}" class="btn btn-secondary">My Account</a>
                  <?php
    }?>
                </div>
                <div class="spec-area__col col-lg-6 order-lg-1">
                  <div class="spec-area__image-holder">
                    <img class="spec-area__img" src="{{get_field('left_image')}}" alt="spec-area__img">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      <!--
      <div class="about-area">
        <div class="container">
          <div class="about-holder">
            <div class="block-heading">
              <div class="block-number">
                <span class="block-number__number">06</span>
                <span class="icon-right-bottom"></span>
              </div>
              {!! get_field('the_team') !!}
            </div>
          </div>
        </div>
        <div class="container">
           <strong class="member-area__title">{!! get_field('left_team_caption') !!}</strong> 
          <div class="panoramawrap">
              <div class="member-area__wrap1">
              @foreach(get_field('teams') as $row)
              @if($row['team_image'])
              <div class="member-area__holder">
                  <div class="info-image">
                      <div class="info-image__wrap1">
                       @if($row['url'])
                       <a href="{!!$row['url']!!}" class="member-area__img-link">
                       @endif
                       <img class="info-image__img" src="{{$row['team_image']['sizes']['post-thumbnail']}}" alt="{{$row['team_member_name']}}">
                        @if($row['url'])
                        </a>
                        @endif
                        <strong class="info-image__info">
                        @if($row['url'])
                          <a href="{!!$row['url']!!}" class="info-image__link">
                        @endif
                        @if($row['team_member_name'])
                            {!!$row['team_member_name']!!}
                        @endif
                        @if($row['url'])
                          </a>
                        @endif
                        </strong>
                      </div>
                    </div>
                </div>
                @endif
             @endforeach
            </div>
          </div>
        </div>
      </div>-->
    </main>
@endsection
