@extends('views.layouts.main')
@section('pre-content')

<main class="main">
    <div class="inner-wrapper">
        <div class="news-section">
            <div class="container">
            <style>
                .srchwrap {
                    border-bottom: 4px solid
                    #555;
                    display: flex;
                    padding: 30px 0 30px;
                    margin: 0 30px;
                    flex-wrap: wrap;
                }
                .srchwrap h4 {
                    text-align: left !important;
                }
                .srchwrap a {
                    margin: 0;
                }
                .srchwrap:last-child {
                    border-bottom: none;
                }
            </style>
                <h1>{{sprintf('Searched Part number : %s', get_search_query())}}</h1>
                @endsection

                @section ('no-content')
                    <h1>Oops! We were not able to find any results!</h1>
                @endsection
                
                @section('content')
                    <div class="searched_product row">
                        @while (have_posts()) @php the_post() @endphp
                        <div class="srchwrap">
                        <div class="col-md-4 col-sm-12 offset-1">
                            @if(get_the_post_thumbnail_url())
                                <img class="card-img-top" src="{{get_the_post_thumbnail_url(get_the_ID(), 'full')}}" alt="Card image" {!! 'style="width:100%"' !!}>
                            @endif
                        </div>
                        <div class="card col-md-7 col-sm-12">
                            <div class="card-body">
                                <h4 class="card-title">{{get_the_title()}}</h4>
                                <p><b>{!! join(', ', wp_list_pluck(get_the_terms( get_the_ID(), 'fittingtype' ), 'name')); !!}</b></p>
                                <p><b>{!! join(', ', wp_list_pluck(get_the_terms( get_the_ID(), 'valvetype' ), 'name')); !!}</b></p>
                                <p>@php echo get_post_meta( get_the_ID(), 'part_description', true ); @endphp</p>
                                <a href="{{get_the_permalink()}}pdf" target="_blank"  class="btn btn-primary">Get Data sheet</a>
                            </div>
                        </div>
                        </div>
                        @endwhile
                    </div>
                @endsection

                @section('post-content')
                        {!!get_the_posts_pagination(array('screen_reader_text' => __('&nbsp;')))!!}
                
            </div>
        </div>
    </div>
</main>
@endsection         

