'use strict';

exports.__esModule = true;
exports.default = scssTokenize;
var SINGLE_QUOTE = 39;
var DOUBLE_QUOTE = 34;
var BACKSLASH = 92;
var SLASH = 47;
var NEWLINE = 10;
var SPACE = 32;
var FEED = 12;
var TAB = 9;
var CR = 13;
var OPEN_SQUARE = 91;
var CLOSE_SQUARE = 93;
var OPEN_PARENTHESES = 40;
var CLOSE_PARENTHESES = 41;
var OPEN_CURLY = 123;
var CLOSE_CURLY = 125;
var SEMICOLON = 59;
var ASTERISK = 42;
var COLON = 58;
var AT = 64;

// SCSS PATCH {
var COMMA = 44;
var HASH = 35;
// } SCSS PATCH

var RE_AT_END = /[ \n\t\r\f\{\(\)'"\\;/\[\]#]/g;
var RE_WORD_END = /[ \n\t\r\f\(\)\{\}:;@!'"\\\]\[#]|\/(?=\*)/g;
var RE_BAD_BRACKET = /.[\\\/\("'\n]/;
var RE_HEX_ESCAPE = /[a-f0-9]/i;

var RE_NEW_LINE = /[\r\f\n]/g; // SCSS PATCH

// SCSS PATCH function name was changed
function scssTokenize(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var css = input.css.valueOf();
    var ignore = options.ignoreErrors;

    var code = void 0,
        next = void 0,
        quote = void 0,
        lines = void 0,
        last = void 0,
        content = void 0,
        escape = void 0,
        nextLine = void 0,
        nextOffset = void 0,
        escaped = void 0,
        escapePos = void 0,
        prev = void 0,
        n = void 0,
        currentToken = void 0;

    var brackets = void 0; // SCSS PATCH

    var length = css.length;
    var offset = -1;
    var line = 1;
    var pos = 0;
    var buffer = [];
    var returned = [];

    function unclosed(what) {
        throw input.error('Unclosed ' + what, line, pos - offset);
    }

    function endOfFile() {
        return returned.length === 0 && pos >= length;
    }

    function nextToken() {
        if (returned.length) return returned.pop();
        if (pos >= length) return;

        code = css.charCodeAt(pos);
        if (code === NEWLINE || code === FEED || code === CR && css.charCodeAt(pos + 1) !== NEWLINE) {
            offset = pos;
            line += 1;
        }

        switch (code) {
            case NEWLINE:
            case SPACE:
            case TAB:
            case CR:
            case FEED:
                next = pos;
                do {
                    next += 1;
                    code = css.charCodeAt(next);
                    if (code === NEWLINE) {
                        offset = next;
                        line += 1;
                    }
                } while (code === SPACE || code === NEWLINE || code === TAB || code === CR || code === FEED);

                currentToken = ['space', css.slice(pos, next)];
                pos = next - 1;
                break;

            case OPEN_SQUARE:
                currentToken = ['[', '[', line, pos - offset];
                break;

            case CLOSE_SQUARE:
                currentToken = [']', ']', line, pos - offset];
                break;

            case OPEN_CURLY:
                currentToken = ['{', '{', line, pos - offset];
                break;

            case CLOSE_CURLY:
                currentToken = ['}', '}', line, pos - offset];
                break;

            // SCSS PATCH {
            case COMMA:
                currentToken = ['word', ',', line, pos - offset, line, pos - offset + 1];
                break;
            // } SCSS PATCH

            case COLON:
                currentToken = [':', ':', line, pos - offset];
                break;

            case SEMICOLON:
                currentToken = [';', ';', line, pos - offset];
                break;

            case OPEN_PARENTHESES:
                prev = buffer.length ? buffer.pop()[1] : '';
                n = css.charCodeAt(pos + 1);
                if (prev === 'url' && n !== SINGLE_QUOTE && n !== DOUBLE_QUOTE && n !== SPACE && n !== NEWLINE && n !== TAB && n !== FEED && n !== CR) {
                    // SCSS PATCH {
                    brackets = 1;
                    escaped = false;
                    next = pos + 1;
                    while (next <= css.length - 1) {
                        n = css.charCodeAt(next);
                        if (n === BACKSLASH) {
                            escaped = !escaped;
                        } else if (n === OPEN_PARENTHESES) {
                            brackets += 1;
                        } else if (n === CLOSE_PARENTHESES) {
                            brackets -= 1;
                            if (brackets === 0) break;
                        }
                        next += 1;
                    }

                    content = css.slice(pos, next + 1);
                    lines = content.split('\n');
                    last = lines.length - 1;

                    if (last > 0) {
                        nextLine = line + last;
                        nextOffset = next - lines[last].length;
                    } else {
                        nextLine = line;
                        nextOffset = offset;
                    }

                    currentToken = ['brackets', content, line, pos - offset, nextLine, next - nextOffset];

                    offset = nextOffset;
                    line = nextLine;
                    pos = next;
                    // } SCSS PATCH
                } else {
                    next = css.indexOf(')', pos + 1);
                    content = css.slice(pos, next + 1);

                    if (next === -1 || RE_BAD_BRACKET.test(content)) {
                        currentToken = ['(', '(', line, pos - offset];
                    } else {
                        currentToken = ['brackets', content, line, pos - offset, line, next - offset];
                        pos = next;
                    }
                }

                break;

            case CLOSE_PARENTHESES:
                currentToken = [')', ')', line, pos - offset];
                break;

            case SINGLE_QUOTE:
            case DOUBLE_QUOTE:
                quote = code === SINGLE_QUOTE ? '\'' : '"';
                next = pos;
                do {
                    escaped = false;
                    next = css.indexOf(quote, next + 1);
                    if (next === -1) {
                        if (ignore) {
                            next = pos + 1;
                            break;
                        } else {
                            unclosed('string');
                        }
                    }
                    escapePos = next;
                    while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
                        escapePos -= 1;
                        escaped = !escaped;
                    }
                } while (escaped);

                content = css.slice(pos, next + 1);
                lines = content.split('\n');
                last = lines.length - 1;

                if (last > 0) {
                    nextLine = line + last;
                    nextOffset = next - lines[last].length;
                } else {
                    nextLine = line;
                    nextOffset = offset;
                }

                currentToken = ['string', css.slice(pos, next + 1), line, pos - offset, nextLine, next - nextOffset];

                offset = nextOffset;
                line = nextLine;
                pos = next;
                break;

            case AT:
                RE_AT_END.lastIndex = pos + 1;
                RE_AT_END.test(css);
                if (RE_AT_END.lastIndex === 0) {
                    next = css.length - 1;
                } else {
                    next = RE_AT_END.lastIndex - 2;
                }

                currentToken = ['at-word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];

                pos = next;
                break;

            case BACKSLASH:
                next = pos;
                escape = true;
                while (css.charCodeAt(next + 1) === BACKSLASH) {
                    next += 1;
                    escape = !escape;
                }
                code = css.charCodeAt(next + 1);
                if (escape && code !== SLASH && code !== SPACE && code !== NEWLINE && code !== TAB && code !== CR && code !== FEED) {
                    next += 1;
                    if (RE_HEX_ESCAPE.test(css.charAt(next))) {
                        while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
                            next += 1;
                        }
                        if (css.charCodeAt(next + 1) === SPACE) {
                            next += 1;
                        }
                    }
                }

                currentToken = ['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];

                pos = next;
                break;

            default:
                // SCSS PATCH {
                n = css.charCodeAt(pos + 1);

                if (code === HASH && n === OPEN_CURLY) {
                    var deep = 1;
                    next = pos;
                    while (deep > 0) {
                        next += 1;
                        if (css.length <= next) unclosed('interpolation');

                        code = css.charCodeAt(next);
                        n = css.charCodeAt(next + 1);

                        if (code === CLOSE_CURLY) {
                            deep -= 1;
                        } else if (code === HASH && n === OPEN_CURLY) {
                            deep += 1;
                        }
                    }

                    content = css.slice(pos, next + 1);
                    lines = content.split('\n');
                    last = lines.length - 1;

                    if (last > 0) {
                        nextLine = line + last;
                        nextOffset = next - lines[last].length;
                    } else {
                        nextLine = line;
                        nextOffset = offset;
                    }

                    currentToken = ['word', content, line, pos - offset, nextLine, next - nextOffset];

                    offset = nextOffset;
                    line = nextLine;
                    pos = next;
                } else if (code === SLASH && n === ASTERISK) {
                    // } SCSS PATCH
                    next = css.indexOf('*/', pos + 2) + 1;
                    if (next === 0) {
                        if (ignore) {
                            next = css.length;
                        } else {
                            unclosed('comment');
                        }
                    }

                    content = css.slice(pos, next + 1);
                    lines = content.split('\n');
                    last = lines.length - 1;

                    if (last > 0) {
                        nextLine = line + last;
                        nextOffset = next - lines[last].length;
                    } else {
                        nextLine = line;
                        nextOffset = offset;
                    }

                    currentToken = ['comment', content, line, pos - offset, nextLine, next - nextOffset];

                    offset = nextOffset;
                    line = nextLine;
                    pos = next;

                    // SCSS PATCH {
                } else if (code === SLASH && n === SLASH) {
                    RE_NEW_LINE.lastIndex = pos + 1;
                    RE_NEW_LINE.test(css);
                    if (RE_NEW_LINE.lastIndex === 0) {
                        next = css.length - 1;
                    } else {
                        next = RE_NEW_LINE.lastIndex - 2;
                    }

                    content = css.slice(pos, next + 1);

                    currentToken = ['comment', content, line, pos - offset, line, next - offset, 'inline'];

                    pos = next;
                    // } SCSS PATCH
                } else {
                    RE_WORD_END.lastIndex = pos + 1;
                    RE_WORD_END.test(css);
                    if (RE_WORD_END.lastIndex === 0) {
                        next = css.length - 1;
                    } else {
                        next = RE_WORD_END.lastIndex - 2;
                    }

                    currentToken = ['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset];

                    buffer.push(currentToken);

                    pos = next;
                }

                break;
        }

        pos++;
        return currentToken;
    }

    function back(token) {
        returned.push(token);
    }

    return {
        back: back,
        nextToken: nextToken,
        endOfFile: endOfFile
    };
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
