"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  var checker = (0, _utils.whitespaceChecker)("newline", expectation, messages);
  return function (root, result) {
    var validOptions = _stylelint.utils.validateOptions(result, ruleName, {
      actual: expectation,
      possible: ["always", "always-multi-line"]
    });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      if (!decl.prop || decl.prop[0] !== "$") {
        return;
      }

      // Get the raw $var, and only that
      var endOfPropIndex = (0, _utils.declarationValueIndex)(decl) + decl.raw("between").length - 1;
      // `$var:`, `$var :`
      var propPlusColon = decl.toString().slice(0, endOfPropIndex);

      var _loop = function _loop(i, l) {
        if (propPlusColon[i] !== ":") {
          return "continue";
        }
        var indexToCheck = propPlusColon.substr(propPlusColon[i], 3) === "/*" ? propPlusColon.indexOf("*/", i) + 1 : i;

        checker.afterOneOnly({
          source: propPlusColon,
          index: indexToCheck,
          lineCheckStr: decl.value,
          err: function err(m) {
            _stylelint.utils.report({
              message: m,
              node: decl,
              index: indexToCheck,
              result: result,
              ruleName: ruleName
            });
          }
        });
        return "break";
      };

      _loop2: for (var i = 0, l = propPlusColon.length; i < l; i++) {
        var _ret = _loop(i, l);

        switch (_ret) {
          case "continue":
            continue;

          case "break":
            break _loop2;}
      }
    });
  };
};

var _utils = require("../../utils");

var _stylelint = require("stylelint");

var ruleName = exports.ruleName = (0, _utils.namespace)("dollar-variable-colon-newline-after");

var messages = exports.messages = _stylelint.utils.ruleMessages(ruleName, {
  expectedAfter: function expectedAfter() {
    return 'Expected newline after ":"';
  },
  expectedAfterMultiLine: function expectedAfterMultiLine() {
    return 'Expected newline after ":" with a multi-line value';
  }
});