"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  var checker = (0, _utils.whitespaceChecker)("space", expectation, messages);
  return function (root, result) {
    var validOptions = _stylelint.utils.validateOptions(result, ruleName, {
      actual: expectation,
      possible: ["always", "never", "always-single-line"]
    });
    if (!validOptions) {
      return;
    }

    variableColonSpaceChecker({
      root: root,
      result: result,
      locationChecker: checker.after,
      checkedRuleName: ruleName
    });
  };
};

exports.variableColonSpaceChecker = variableColonSpaceChecker;

var _utils = require("../../utils");

var _stylelint = require("stylelint");

var ruleName = exports.ruleName = (0, _utils.namespace)("dollar-variable-colon-space-after");

var messages = exports.messages = _stylelint.utils.ruleMessages(ruleName, {
  expectedAfter: function expectedAfter() {
    return 'Expected single space after ":"';
  },
  rejectedAfter: function rejectedAfter() {
    return 'Unexpected whitespace after ":"';
  },
  expectedAfterSingleLine: function expectedAfterSingleLine() {
    return 'Expected single space after ":" with a single-line value';
  }
});

function variableColonSpaceChecker(_ref) {
  var locationChecker = _ref.locationChecker,
      root = _ref.root,
      result = _ref.result,
      checkedRuleName = _ref.checkedRuleName;

  root.walkDecls(function (decl) {
    if (decl.prop === undefined || decl.prop[0] !== "$") {
      return;
    }

    // Get the raw $var, and only that
    var endOfPropIndex = (0, _utils.declarationValueIndex)(decl) + decl.raw("between").length - 1;
    // `$var:`, `$var :`
    var propPlusColon = decl.toString().slice(0, endOfPropIndex);

    var _loop = function _loop(i) {
      if (propPlusColon[i] !== ":") {
        return "continue";
      }
      locationChecker({
        source: propPlusColon,
        index: i,
        lineCheckStr: decl.value,
        err: function err(m) {
          _stylelint.utils.report({
            message: m,
            node: decl,
            index: i,
            result: result,
            ruleName: checkedRuleName
          });
        }
      });
      return "break";
    };

    _loop2: for (var i = 0; i < propPlusColon.length; i++) {
      var _ret = _loop(i);

      switch (_ret) {
        case "continue":
          continue;

        case "break":
          break _loop2;}
    }
  });
}