"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation, options) {
  return function (root, result) {
    var validOptions = _stylelint.utils.validateOptions(result, ruleName, {
      actual: expectation,
      possible: ["always", "never"]
    }, {
      actual: options,
      possible: {
        except: ["first-nested", "after-comment", "after-dollar-variable"],
        ignore: ["after-comment", "inside-single-line-block"]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      if (!isDollarVar(decl)) {
        return;
      }

      // Always ignore the first $var in a stylesheet
      if (decl === root.first) {
        return;
      }

      // If ignoring vars after comments is set
      if ((0, _utils.optionsHaveIgnored)(options, "after-comment") && decl.prev() && decl.prev().type === "comment") {
        return;
      }

      // If ignoring single-line blocks
      if ((0, _utils.optionsHaveIgnored)(options, "inside-single-line-block") && decl.parent.type !== "root" && (0, _utils.isSingleLineString)((0, _utils.blockString)(decl.parent))) {
        return;
      }

      var expectHasEmptyLineBefore = expectation === "always";

      // Reverse for a variable that is a first child of its parent
      if ((0, _utils.optionsHaveException)(options, "first-nested") && decl === decl.parent.first) {
        expectHasEmptyLineBefore = !expectHasEmptyLineBefore;
      }

      // Reverse if after a comment
      if ((0, _utils.optionsHaveException)(options, "after-comment") && decl.prev() && decl.prev().type === "comment") {
        expectHasEmptyLineBefore = !expectHasEmptyLineBefore;
      }

      // Reverse if after another $-variable
      if ((0, _utils.optionsHaveException)(options, "after-dollar-variable") && decl.prev() && isDollarVar(decl.prev())) {
        expectHasEmptyLineBefore = !expectHasEmptyLineBefore;
      }

      if (expectHasEmptyLineBefore === (0, _utils.hasEmptyLine)(decl.raws.before)) {
        return;
      }

      _stylelint.utils.report({
        message: expectHasEmptyLineBefore ? messages.expected : messages.rejected,
        node: decl,
        result: result,
        ruleName: ruleName
      });
    });
  };
};

var _utils = require("../../utils");

var _stylelint = require("stylelint");

var ruleName = exports.ruleName = (0, _utils.namespace)("dollar-variable-empty-line-before");

var messages = exports.messages = _stylelint.utils.ruleMessages(ruleName, {
  expected: "Expected an empty line before $-variable",
  rejected: "Unxpected empty line before $-variable"
});

function isDollarVar(node) {
  return node.prop && node.prop[0] === "$";
}