# operator-no-newline-after

Disallow linebreaks after Sass operators.

```scss
a { width: 10px + $n; }
/**             ↑
 * Linebreaks after this */
```

This rule checks math operators (`+`, `-`, `/`, `*`, `%`) and comparison operators (`>`, `<`, `!=`, `==`, `>=`, `<=`).

Not all symbols that correspond to math operators are actually considered operators by Sass. Some of the exceptions are:

* `+` and `-` as signs before values;
* `+` and `-` as signs in [space-delimited lists](http://sass-lang.com/documentation/file.SASS_REFERENCE.html#string_operations);
* `-` as part of [a string](http://sass-lang.com/documentation/file.SASS_REFERENCE.html#string_operations) or [a Sass identifier](http://sass-lang.com/documentation/file.SASS_REFERENCE.html#subtraction), e.g. a variable;
* `/` as a CSS delimiter in property values like `font: 10px/1.2 Arial;` ([read more](http://sass-lang.com/documentation/file.SASS_REFERENCE.html#division-and-slash)).

For more details refer to [Sass official documentation](http://sass-lang.com/documentation/file.SASS_REFERENCE.html). An online Sass compiler - [Sassmeister](http://www.sassmeister.com/) - could also come in handy.

The following patterns are considered warnings:

```scss
a { width: 10 +
1; }
```

```scss
a {
  width: 10 +
    1;
}
```

The following patterns are *not* considered warnings:

```scss
a {
  width: str- // not a math operator, ignored
    some;
}
```

```scss
a { width: 10px     -    1; }
```

```scss
a {
  width: 10px * 1.7 // the newline is not right after the operator
    + 1;
}
```
