<?php

// AJAX Load More
function enqueue_ajax_load_more()
{
    wp_enqueue_script('ajax-load-more');
}
add_action('wp_head', 'enqueue_ajax_load_more');

// filter Ajax function
function ajax_request_filter()
{
    if ($_POST['onClick'] == 'filter') {
        echo search_results($_POST);
        die();
    }

    if ($_POST['onClick'] == 'Data Sheet') {
        echo get_data_sheet($_POST);
        die();
    }

    if ($_POST['onClick'] == 'Request Quote') {
        echo request_quote($_POST);
        die();
    }

    if ($_POST['onClick'] == 'Save') {
		global $wpdb;
		$values = serialize($_POST);
		    $table_name = $wpdb->prefix . 'user_searches_temp';
				$val = $wpdb->insert(
					$table_name,
					array(
						'json_data' => $values
					),
				array('%s')
			);
        if (isset($_COOKIE["form_search_data"]) && $_GET['success'] = 'yes') {
            $formdata = unserialize(base64_decode($_COOKIE["form_search_data"]));
            unset($_COOKIE['form_search_data']);
            setcookie('form_search_data', null, -1, '/');
        } else {
            if (!is_user_logged_in()) {
                setcookie('form_search_data', base64_encode(serialize($_POST)), (time() + 3600), "/");
            }
            $formdata = $_POST;
        }
        $data = save_product_search($formdata);
        if (is_user_logged_in()) {
            $url = get_permalink(368);
            echo json_encode(array('status' => false, 'clicked' => 'save', 'data' => $data, 'url' => $url));
        } else {
            echo json_encode(array('status' => false, 'clicked' => 'save', 'data' => $data));
        }
        die();
    }
}

add_action('wp_ajax_filterProducts', 'ajax_request_filter');
add_action('wp_ajax_nopriv_filterProducts', 'ajax_request_filter');

function ajax_ultimate_request_filter(){
if($_POST['action'] == 'ultimateAjaxProduct' && $_POST['data']['login']=='true'){
		$username = $_POST['data']['username'];
		$exists =  email_exists($username);
		if ($exists){
			$user = get_user_by( 'email', $username);
			$userid = $user->ID;
		}else{
			$user = get_userdatabylogin($username);
			$userid = $user->ID;
		}	
		save_product_search_ultimate($userid);
	}
	echo 'Saved';
	die();
}
add_action('wp_ajax_ultimateAjaxProduct', 'ajax_ultimate_request_filter');
add_action('wp_ajax_nopriv_ultimateAjaxProduct', 'ajax_ultimate_request_filter');

//Save User Product Search data afetr ultimate login
function save_product_search_ultimate($userid)
{
global $wpdb;
$myrows = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}user_searches_temp ORDER BY id DESC LIMIT 1", ARRAY_A);
$jsondecode = unserialize($myrows['json_data']);
if ($jsondecode['valvetype'] != "" || $jsondecode['fittingtype'] != "") {
        if ($jsondecode['valvetype'] != "") {
            $type_id = $jsondecode['valvetype'];
        } else {
            $type_id = $jsondecode['fittingtype'];
        }
    }
    if ($userid == "") {
        return "";
        die();
    }
    $product_id = search_result_product_id($jsondecode); 
    $table_name = $wpdb->prefix . 'user_searches';
	$current_date = date("Y-m-d H:i:s");
    $val = $wpdb->insert(
        $table_name,
        array(
            'user_id' => $userid,
            'category_id' => $jsondecode['productcategory'],
            'type_id' => $type_id,
            'product_id' => $product_id,
            'valve_actuator' => $jsondecode['field_5ab203bebaf19'],
            'valve_series' => $jsondecode['field_5ab2043f5c31e'],
            'valve_body_style' => $jsondecode['field_5ab2044b5c31f'],
            'valve_size__port_dia' => stripslashes($jsondecode['field_5ab204525c320']),
            'valve_connection' => $jsondecode['field_5ab2045a5c321'],
            'fitting_series' => $jsondecode['field_5ab212414087b'],
            'fitting_description' => $jsondecode['field_5ab212534087d'],
            'fitting_model' => $jsondecode['field_5ab2125f4087e'],
            'fitting_connection_1' => $jsondecode['field_5ab2126d4087f'],
            'fitting_connection_2' => $jsondecode['field_5ab2128a40880'],
            'fitting_connection_3' => $jsondecode['field_5ab2128f40881'],
            'fitting_connection_4' => $jsondecode['field_5ab2129240882'],
            'fitting_material' => $jsondecode['field_5ab212a040883'],
			'created_at' => $current_date
        ),
        array('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')
    );
  
}
// Search product from post type product according to search filter.
function search_results($post_data)
{
    $args = create_search_arg($post_data);
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $count = 1;
    while ($query->have_posts()): $query->the_post();
    if ($count == 1) {
        $product['id'] .= get_the_ID();
        $product['title'] .= get_the_title();
		$product['permalink'] .= get_permalink() . "pdf";
        $product['part_number'] .= get_field('part_number');
        $image_id .= get_post_thumbnail_id(get_the_ID());
        if ($image_id) {
            $product['image'] = wp_get_attachment_url($image_id);
        } else {
            if ($post_data['productcategory'] == "valves") {
                $product['image'] = site_url() . '/../app/uploads/2018/03/15.jpg';
            } else {
                $product['image'] = site_url() . '/../app/uploads/2018/03/02.jpg';
            }
        }
    }
    $count++;
    endwhile;
    wp_reset_postdata(); else:
        $product['part_number'] = 'No posts found';
    if ($post_data['productcategory'] == "valves") {
        $product['image'] = site_url() . '/../app/uploads/2018/03/15.jpg';
    } else {
        $product['image'] = site_url() . '/../app/uploads/2018/03/02.jpg';
    }
    endif;
    return json_encode(array('status' => false, 'clicked' => 'filter', 'data' => $product));
}

// Get request quote form of searched prodduct.
function request_quote($post_data)
{
    $args = create_search_arg($post_data);
    $query = new WP_Query($args);
    if ($query->have_posts()):
        while ($query->have_posts()):
            $query->the_post();
    $product .= get_the_title();
    endwhile;
    wp_reset_postdata(); else:
        $product = '';
    endif;
    return json_encode(array('status' => true, 'clicked' => 'req_quote', 'data' => $product));
}

// function for get data sheet.
function get_data_sheet($post_data)
{
    $args = create_search_arg($post_data);
    $query = new WP_Query($args);
    if ($query->have_posts()):
        while ($query->have_posts()): $query->the_post();
    $filepath = get_permalink() . "/pdf";
    return json_encode(array('status' => true, 'clicked' => 'data_sheet', 'url' => $filepath));
    endwhile;
    wp_reset_postdata(); else:
        return json_encode(array('status' => false, 'clicked' => 'data_sheet', 'data' => 'No Data Sheet Available'));
    endif;
}

function create_search_arg($post_values)
{
    $args = array(
        'post_type' => 'products',
        'posts_per_page' => -1,
        'orderby' => 'date', // we will sort posts by date
        'order' => 'ASC', // ASC & DESC
    );
    // for taxonomies / categories
    if (isset($post_values['productcategory']) && isset($post_values['valvetype'])) {
        $args['tax_query'] = array(
            'relation' => 'AND',
            array(
                'taxonomy' => 'productcategory',
                'field' => 'id',
                'terms' => $post_values['productcategory'],
            ),
            array(
                'taxonomy' => 'valvetype',
                'field' => 'id',
                'terms' => $post_values['valvetype'],
            ),
        );
    }
    if (isset($post_values['productcategory']) && isset($post_values['fittingtype'])) {
        $args['tax_query'] = array(
            'relation' => 'AND',
            array(
                'taxonomy' => 'productcategory',
                'field' => 'id',
                'terms' => $post_values['productcategory'],
            ),
            array(
                'taxonomy' => 'fittingtype',
                'field' => 'id',
                'terms' => $post_values['fittingtype'],
            ),
        );
    }

    $have_values = false;
    foreach ($post_values as $key => $value) {
        $exp_key = explode('_', $key);
        if ($exp_key[0] == 'field') {
            $fields[] = $key;
            if (isset($post_values[$key])) {
                $have_values = true;
            }
        }
    }
    // create $args['meta_query'] array if one of the following fields is filled
    if ($have_values) {
        $args['meta_query'] = array('relation' => 'AND'); // AND means that all conditions of meta_query should be true
    }
    foreach ($fields as $value) {
        if ($post_values[$value] != '') {
            $key = get_field_object($value);
            $args['meta_query'][] = array(
                'key' => $key['name'],
                'value' => stripslashes($post_values[$value]),
                'compare' => '=',
            );
        }
    }
    return $args;
}

// Get Select Custom Field
function get_select_custom_field_with_series($field_key, $product_type)
{
    $fieldSeries = get_field_object($field_key);

    if ($fieldSeries && $fieldSeries['key']=='field_5ab212414087b') {
        echo "<div class='" . $fieldSeries['name'] . "'>";
        echo '<select disabled="disabled" class="cpv_filter ' . $product_type . '_' . $fieldSeries['name'] . ' customSeriesDropdown" data-loader="loader" name="' . $field_key . '">';
        foreach ($fieldSeries['choices'] as $key => $value) {
            echo "<option value='" . $key . "'>" . $value . "</option>";
        }
        echo '</select>';
        echo "</div>";
    }
}


// Get Select Custom Field
function get_select_custom_field($field_key, $product_type)
{
    $field = get_field_object($field_key);
    
    if ($field) {
        echo "<div class='" . $field['name'] . "'>";
        $image_attributes = wp_get_attachment_image_src($attachment_id = 355, 'full');
        if ($image_attributes):
            echo '<div class="loader_wrapper"><img class="loader" src="' . $image_attributes[0] . '" ?></div>';
        endif;
        echo '<select disabled="disabled" class="cpv_filter ' . $product_type . '_' . $field['name'] . '" data-loader="loader" name="' . $field_key . '">';
        foreach ($field['choices'] as $key => $value) {
            echo "<option value='" . $key . "'>" . $value . "</option>";
        }
        echo '</select>';
        echo "</div>";
    }
}



// Get Select Taxonomy Field
function get_select_taxo_field($taxo)
{
    $terms = get_terms($taxo, array('hide_empty' => true, 'parent' => 0));
	
  
    if ($terms): 
    echo "<div class='" . $taxo . "'>";
    echo '<select class="cpv_box_filter type_id" id=' . $taxo . ' name=' . $taxo . ' required>';
    foreach ($terms as $term):
            if (get_field('image', $taxo . '_' . $term->term_id)['sizes']['large']) {
                echo '<option value="' . $term->term_id . '" description="' . $term->description . '" image="' . get_field('image', $taxo . '_' . $term->term_id)['sizes']['large'] . '">' . $term->name . '</option>'; // ID of the category as the value of an option
            } elseif ($taxo == "valvetype") {
                echo '<option value="' . $term->term_id . '" description="' . $term->description . '" image="' . home_url() . '/app/uploads/2018/03/02.jpg">' . $term->name . '</option>'; // ID of the category as the value of an option
            } else {
                echo '<option value="' . $term->term_id . '" description="' . $term->description . '" image="' . home_url() . '/app/uploads/2018/03/15.jpg">' . $term->name . '</option>'; // ID of the category as the value of an option
            }
    endforeach;
    echo '</select>';
    echo "</div>";
    endif;
}
// Get Search fields 
function get_serach_field(){
	if(isset($_GET['search'])){
		echo 'hide';
	}else{
		echo 'show';
	}
}
//Save User Product Search
function save_product_search($formValues)
{
    if ($formValues['valvetype'] != "" || $formValues['fittingtype'] != "") {
        if ($formValues['valvetype'] != "") {
            $type_id = $formValues['valvetype'];
        } else {
            $type_id = $formValues['fittingtype'];
        }
    }
    if (get_current_user_id() == "") {
        return "";
        die();
    }
    if (get_current_user_id() != "" && isset($_COOKIE["form_search_data"])) {
        return "";
        die();
    }
    $product_id = search_result_product_id($formValues);
    global $wpdb;
    $table_name = $wpdb->prefix . 'user_searches';
	$current_date = date("Y-m-d H:i:s");
    $val = $wpdb->insert(
        $table_name,
        array(
            'user_id' => get_current_user_id(),
            'category_id' => $formValues['productcategory'],
            'type_id' => $type_id,
            'product_id' => $product_id,
            'valve_actuator' => $formValues['field_5ab203bebaf19'],
            'valve_series' => $formValues['field_5ab2043f5c31e'],
            'valve_body_style' => $formValues['field_5ab2044b5c31f'],
            'valve_size__port_dia' => stripslashes($formValues['field_5ab204525c320']),
            'valve_connection' => $formValues['field_5ab2045a5c321'],
            'fitting_series' => $formValues['field_5ab212414087b'],
            'fitting_description' => $formValues['field_5ab212534087d'],
            'fitting_model' => $formValues['field_5ab2125f4087e'],
            'fitting_connection_1' => $formValues['field_5ab2126d4087f'],
            'fitting_connection_2' => $formValues['field_5ab2128a40880'],
            'fitting_connection_3' => $formValues['field_5ab2128f40881'],
            'fitting_connection_4' => $formValues['field_5ab2129240882'],
            'fitting_material' => $formValues['field_5ab212a040883'],
			'created_at' => $current_date
        ),
        array('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')
    );
    return "Saved!";
}

add_action('wp_ajax_get_terms_for_series', 'get_terms_for_series');
add_action('wp_ajax_nopriv_get_terms_for_series', 'get_terms_for_series');

function get_terms_for_series()
{
    parse_str($_REQUEST[current_selected], $output);
    echo get_type_dropdown($output, $_REQUEST[opteration_on]);
    die;
}
function get_type_dropdown($data, $key)
{
    $args = array(
         'post_type'      => 'products',
         'posts_per_page'  => -1,
         'post_status'       => 'publish',
         'meta_query'  => array(
             array(
              'key'       => 'f_series',
              'value'     => $key,
              'compare'   => '='
             )
            )
        );
    $taxo = 'fittingtype';
    $the_query = new WP_Query($args);
    $termArr  = array();
    $box = '<select class="cpv_box_filter type_id" id=' . $taxo . ' name=' . $taxo . ' required>';
    if ($the_query->have_posts()) {
        while ($the_query->have_posts()) {
            $the_query->the_post();
            $terms = get_the_terms(get_the_ID(), array( 'fittingtype'));
         
            foreach ($terms as $key=>$term) {
                if (!in_array($term->term_id, $termArr)) {
                    $box .= '<option value="' . $term->term_id . '" description="' . $term->description . '" image="' . get_field('image', $taxo . '_' . $term->term_id)['sizes']['thumbnail'] . '">' . $term->name . '</option>'; // ID of the category as the value of an option
                    $termArr[$key] = $term->term_id;
                }
            }
        }
        $box .='</select>';
        echo $box;
    }

    // Reset Post Data
    wp_reset_postdata();
}



add_action('wp_ajax_get_terms_for_cpt', 'get_terms_for_cpt');
add_action('wp_ajax_nopriv_get_terms_for_cpt', 'get_terms_for_cpt');

function get_terms_for_cpt()
{
    parse_str($_REQUEST[current_selected], $output);
    echo get_field_dropdown($output, $_REQUEST[opteration_on]);
    die;
}

function get_field_dropdown($data, $key)
{
    if ($data[productcategory] != "") {
        unset($data[$key]);
        $args = create_search_arg($data);
        $field_name = get_field_object($key)['name'];
        $query = new WP_Query($args);
        if ($query->have_posts()):
            $select_fields = array();
        while ($query->have_posts()): $query->the_post();
        if (get_field($field_name) != "") {
            array_push($select_fields, get_field($field_name));
        }
        endwhile;
        endif;
        $select_fields = array_unique($select_fields);
        if (empty($select_fields)) {
            $list_of_custom_field = '';
        } else {
            $list_of_custom_field .= '<select class="cpv_filter" id="' . $key . '" name="' . $key . '" required="">';
            if (array_key_exists("valvetype", $data)) {
                foreach ($select_fields as $field) {
                    $list_of_custom_field .= "<option value='" . htmlentities($field) . "' " . get_description(htmlentities($field)) . ">" . htmlentities($field) . "</option>";
                }
            } else {
                foreach ($select_fields as $field) {
                    $list_of_custom_field .= "<option value='" . htmlentities($field) . "' " . get_description(htmlentities('Fittings '.$field)) . ">" . htmlentities($field) . "</option>";
                }
            }
            $list_of_custom_field .= '</select>';
        }
        return $list_of_custom_field;
    }
}

// Search product id of searched product
function search_result_product_id($post_data)
{
    $args = create_search_arg($post_data);
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $count = 1;
    while ($query->have_posts()): $query->the_post();
    if ($count == 1) {
        $product['id'] .= get_the_ID();
    }
    $count++;
    endwhile;
    endif;
    wp_reset_postdata();
    return $product['id'];
}

// get all unique search results
function get_searched_products($user_id)
{
    global $wpdb;
    $results = $wpdb->get_results("SELECT id,product_id,category_id,created_at FROM {$wpdb->prefix}user_searches WHERE user_id ='" . $user_id . "' GROUP BY product_id", OBJECT);
    return $results;
}
if (!is_admin()) {
    add_filter('pre_get_posts', 'my_get_posts');
    function my_get_posts($query)
    {
        if (isset($query->query['s'])) {
            $query->set('post_type', 'products');
            $query->set('meta_key', 'part_number');
            $query->set('orderby', 'part_number');
            $query->set('order', 'ASC');
            $query->set('meta_query', array(
                array(
                    'key' => 'part_number',
                    'value' => $_GET['s'],
                    'compare' => 'like',
                ),
            ));
        }
        return $query;
    }
}

if (function_exists('set_pdf_print_support')) {
    set_pdf_print_support(array('products'));
}

add_filter('gform_enable_field_label_visibility_settings', '__return_true');

add_action('wp_ajax_filternews', 'filternews');
add_action('wp_ajax_nopriv_filternews', 'filternews');

function filternews()
{
    unset($_REQUEST['action']);
    $categories = implode(",", $_REQUEST);
    echo do_shortcode('[ajax_load_more repeater="template_8" post_type="news" taxonomy="news-category" taxonomy_terms="' . $categories . '" taxonomy_operator="IN" posts_per_page="6" label="Load More"  pause="false" scroll="false" transition="masonry" masonry_selector=".news-block" masonry_animation="slide-up"]');
    die();
}

add_action('wp_ajax_delete_search', 'delete_search');
add_action('wp_ajax_nopriv_delete_search', 'delete_search');
function delete_search()
{
    global $wpdb;
    $wpdb->query(
        'DELETE  FROM ' . $wpdb->prefix . 'user_searches
        WHERE id = "' . $_REQUEST['id'] . '"'
    );
}

add_action('wp_ajax_view_product', 'view_product');
add_action('wp_ajax_nopriv_view_product', 'view_product');
function view_product()
{
    global $wpdb;
    $user_id = get_current_user_id();
    $results = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}user_searches WHERE user_id ='" . $user_id . "' AND id='" . $_REQUEST['id'] . "'GROUP BY product_id", ARRAY_A);
    echo json_encode(current($results));
    die;
}
add_action('init', 'script_enqueuer');
function script_enqueuer()
{
    wp_localize_script('read-me-later', 'readmelater_ajax', array('ajax_url' => admin_url('admin-ajax.php')));
}
// add feature of add post thumbnail from csv import
add_filter('really_simple_csv_importer_post_saved', function ($post) {
    if (is_object($post)) {
        // Get the meta data of which key is "image"
        $image = $post->image;
        // Create a instance of helper class
        $h = RSCSV_Import_Post_Helper::getByID($post->ID);
        // Get the remote image data
        $file = $h->remoteGet($image);
        // Then, attach it
        $attachment_id = $h->setAttachment($file);
        // Finally, replace the original data with the attachment id
        set_post_thumbnail($post->ID, $attachment_id);
    }
});

function get_description($value)
{
	$dropArray  = array();
    if (have_rows('options', 'option')):
	while (have_rows('options', 'option')): the_row();
	$image_thumbnail = get_sub_field('image');

	if (is_array($image_thumbnail)) {
		$details = $image_thumbnail['sizes']['large'];
	} else {
		$details ="";
	}
	$dropArray[htmlentities(get_sub_field('name'))]['image']	=	$details; 
	$dropArray[htmlentities(get_sub_field('name'))]['desc']	=	get_sub_field("description"); 
    
    endwhile;
	if (isset($dropArray[$value])) {
        $data= 'description="' . $dropArray[$value]['desc'] . '" image="' . $dropArray[$value]['image'] . '"';
        return $data;
    }else{
		 return 'description="" image=""';
	}
    endif;
}

/**
 * Allow logout without confirmation
*/
add_action('check_admin_referer', 'logout_without_confirm', 10, 2);
function logout_without_confirm($action, $result)
{
    if ($action == "log-out" && !isset($_GET['_wpnonce'])) {
        $redirect_to = isset($_REQUEST['redirect_to']) ? $_REQUEST['redirect_to'] : 'https://cpv.stage.demotesturl.net';
        $location = str_replace('&amp;', '&', wp_logout_url($redirect_to));
        header("Location: $location");
        die;
    }
}
add_action('admin_init', 'disable_dashboard');
function disable_dashboard() {
	if (defined('DOING_AJAX') && DOING_AJAX===true ) {
        return;
    }
    if (current_user_can('subscriber')) {
        wp_redirect(home_url());
        exit;
    }
}
if(!current_user_can('administrator')) {
	if(is_admin_bar_showing()) {
		show_admin_bar(false);
	}
}

add_filter( 'body_class', 'custom_class' );
function custom_class( $classes ) {
    if ( is_page_template( 'mastervalve.php' ) ) {
        $classes[] = 'nut-page';
    }
    return $classes;
}