<?php

if (!function_exists('cpv_new_posttype')) {
    // Create Post Type for Product
    function setup_posttypes()
    {
        register_post_type(
            'Products',
            array(
                'labels' => array(
                    'name' => __('Products'),
                    'singular_name' => __('Product'),
                    'add_new' => __('Add New Products'),
                    'add_new_item' => __('Add New Products'),
                    'edit_item' => __('Edit Products'),
                    'new_item' => __('Add New Products'),
                    'view_item' => __('View Products'),
                    'search_items' => __('Search Products'),
                    'not_found' => __('No Products found'),
                    'not_found_in_trash' => __('No Products found in trash'),
                ),
                'public' => true,
                'supports' => array('title', 'editor', 'excerpt', 'page-attributes', 'thumbnail', 'author'),
                'capability_type' => 'post',
                'rewrite' => array("slug" => "products", 'with_front' => false), // Permalinks format
                'menu_position' => 5,
            )
        );
        register_post_type(
            'Technical Resources',
            array(
                'labels' => array(
                    'name' => __('Technical Resources'),
                    'singular_name' => __('Product'),
                    'add_new' => __('Add New Technical Resources'),
                    'add_new_item' => __('Add New Technical Resources'),
                    'edit_item' => __('Edit Technical Resources'),
                    'new_item' => __('Add New Technical Resources'),
                    'view_item' => __('View Technical Resources'),
                    'search_items' => __('Search Technical Resources'),
                    'not_found' => __('No Technical Resources found'),
                    'not_found_in_trash' => __('No Technical Resources found in trash'),
                ),
                'public' => true,
                'supports' => array('title', 'editor', 'excerpt', 'page-attributes', 'thumbnail', 'author'),
                'capability_type' => 'post',
                'rewrite' => array("slug" => "technical-resources", 'with_front' => false), // Permalinks format
                'menu_position' => 5,
            )
        );
        
        register_post_type(
            'News',
            array(
                'labels' => array(
                    'name' => __('News'),
                    'singular_name' => __('News'),
                    'add_new' => __('Add New News'),
                    'add_new_item' => __('Add New News'),
                    'edit_item' => __('Edit News'),
                    'new_item' => __('Add New News'),
                    'view_item' => __('View News'),
                    'search_items' => __('Search News'),
                    'not_found' => __('No News found'),
                    'not_found_in_trash' => __('No News found in trash'),
                ),
                'public' => true,
                'supports' => array('title', 'editor', 'excerpt', 'page-attributes', 'thumbnail', 'author'),
                'capability_type' => 'post',
                'rewrite' => array("slug" => "news", 'with_front' => false), // Permalinks format
                'menu_position' => 4,
            )
        );
    }
}

add_action('init', 'setup_posttypes');

if (!function_exists('cpv_taxonomies')) {
    function cpv_taxonomies()
    {
        $labels = array(
            'name' => _x('Product Categories', 'taxonomy general name'),
            'singular_name' => _x('Product Category', 'taxonomy singular name'),
            'search_items' => __('Search Product Categories'),
            'all_items' => __('All Product Categories'),
            'parent_item' => __('Parent Product Category'),
            'parent_item_colon' => __('Parent Product Category:'),
            'edit_item' => __('Edit Product Category'),
            'update_item' => __('Update Product Category'),
            'add_new_item' => __('Add New Product Category'),
            'new_item_name' => __('New Product Category'),
            'menu_name' => __('Product Categories'),
        );

        $args = array(
            'labels' => $labels,
            'hierarchical' => true,
        );
        register_taxonomy('productcategory', 'products', $args);

        $labels = array(
            'name' => _x('Valve Types', 'taxonomy general name'),
            'singular_name' => _x('Valve Type', 'taxonomy singular name'),
            'search_items' => __('Search Valve Types'),
            'all_items' => __('All Valve Types'),
            'parent_item' => __('Parent Valve Type'),
            'parent_item_colon' => __('Parent Valve Type:'),
            'edit_item' => __('Edit Valve Type'),
            'update_item' => __('Update Valve Type'),
            'add_new_item' => __('Add New Valve Type'),
            'new_item_name' => __('New Valve Type'),
            'menu_name' => __('Valve Type'),
        );

        $args = array(
            'labels' => $labels,
            'hierarchical' => true,
        );

        register_taxonomy('valvetype', 'products', $args);

        $labels = array(
            'name' => _x('Series', 'taxonomy general name'),
            'singular_name' => _x('Series', 'taxonomy singular name'),
            'search_items' => __('Search Series'),
            'all_items' => __('All Series'),
            'parent_item' => __('Parent Series'),
            'parent_item_colon' => __('Parent Series:'),
            'edit_item' => __('Edit Series'),
            'update_item' => __('Update Series'),
            'add_new_item' => __('Add New Series'),
            'new_item_name' => __('New Series'),
            'menu_name' => __('Series'),
        );

        $args = array(
            'labels' => $labels,
            'hierarchical' => true,
        );
        register_taxonomy('fittingtype', 'products', $args);
        
        $labels = array(
            'name' => _x('News Categories', 'taxonomy general name'),
            'singular_name' => _x('News Category', 'taxonomy singular name'),
            'search_items' => __('Search News Categories'),
            'all_items' => __('All News Categories'),
            'parent_item' => __('Parent News Category'),
            'parent_item_colon' => __('Parent News Category:'),
            'edit_item' => __('Edit News Category'),
            'update_item' => __('Update News Category'),
            'add_new_item' => __('Add New News Category'),
            'new_item_name' => __('New News Category'),
            'menu_name' => __('News Categories'),
        );

        $args = array(
            'labels' => $labels,
            'hierarchical' => true,
        );
        register_taxonomy('news-category', 'news', $args);
    }
    $labels = array(
        'name' => _x('Tags', 'taxonomy general name'),
        'singular_name' => _x('Tag', 'taxonomy singular name'),
        'search_items' =>  __('Search Tags'),
        'popular_items' => __('Popular Tags'),
        'all_items' => __('All Tags'),
        'parent_item' => null,
        'parent_item_colon' => null,
        'edit_item' => __('Edit Tag'),
        'update_item' => __('Update Tag'),
        'add_new_item' => __('Add New Tag'),
        'new_item_name' => __('New Tag Name'),
        'separate_items_with_commas' => __('Separate tags with commas'),
        'add_or_remove_items' => __('Add or remove tags'),
        'choose_from_most_used' => __('Choose from the most used tags'),
        'menu_name' => __('Tags'),
      );
    
    register_taxonomy('tag', 'news', array(
        'hierarchical' => false,
        'labels' => $labels,
        'show_ui' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array( 'slug' => 'tag' ),
      ));

    $labels = array(
        'name' => _x('Types', 'taxonomy general name'),
        'singular_name' => _x('Type', 'taxonomy singular name'),
        'search_items' => __('Search Types'),
        'all_items' => __('All Types'),
        'parent_item' => __('Parent Type'),
        'parent_item_colon' => __('Parent Type:'),
        'edit_item' => __('Edit Type'),
        'update_item' => __('Update Type'),
        'add_new_item' => __('Add New Type'),
        'new_item_name' => __('New Type'),
        'menu_name' => __('Type'),
    );

    $args = array(
        'labels' => $labels,
        'hierarchical' => true,
    );

    register_taxonomy('type', 'technicalresources', $args);

    $labels = array(
        'name' => _x('Resource Categories', 'taxonomy general name'),
        'singular_name' => _x('Resource Category', 'taxonomy singular name'),
        'search_items' => __('Search Resource Categorys'),
        'all_items' => __('All Resource Categories'),
        'parent_item' => __('Parent Resource Category'),
        'parent_item_colon' => __('Parent Resource Category:'),
        'edit_item' => __('Edit Resource Category'),
        'update_item' => __('Update Resource Category'),
        'add_new_item' => __('Add New Resource Category'),
        'new_item_name' => __('New Resource Category'),
        'menu_name' => __('Resource Category'),
    );

    $args = array(
        'labels' => $labels,
        'hierarchical' => true,
    );

    register_taxonomy('resource-category', 'technicalresources', $args);
}
add_action('init', 'cpv_taxonomies', 0);
