<?php
   /**
    * Filename: index-pdf.php
    * Project: WordPress PDF Templates
    * Copyright: (c) 2014-2016 Antti Kuosmanen
    * License: GPLv3
    *
    */
   ?>
<!DOCTYPE html>
<html>
   <head>
      <title><?php wp_title();?></title>
      <?php wp_head();?>
      <link href="https://fonts.googleapis.com/css?family=Work+Sans" rel="stylesheet">
      <style>
         body {
         font-family: 'Work Sans', sans-serif;
         font-size:12px;
         }
         @page { margin: 100px 25px; }
         .top_header{position: fixed; top: -100px; left: -25px; right: -25px; height: 50px;}
         header { height: 200px;}
         footer { position: fixed; bottom: 10px; left: -25px; right: -25px; height: 20px; }
         p { page-break-after: always; }
         p:last-child { page-break-after: never; }
         .logo_text{
               font-weight:700;
               font-style: italic;
               margin:100px;
         }
         main{
         margin-top:100px;
         }
         th{
               font-weight:600;
         }
         .table8 tr:nth-child(odd) {
         background-color: #d0d0d0;
         }
         .table8 tr:nth-child(even) {
         background-color: #fff;
         }
      </style>
   </head>
   <body>
   <?php $product_category=get_the_terms( get_the_id(), 'productcategory' );
   ?>
      <div class="top_header">
         <header>
            <table cellspacing="0" cellpadding="0" border="0" width="100%" bgcolor="#d0d0d0">
               <tr >
                  <td width="50%" style="padding:10px 20px 10px 30px"> 
                     <table>
                        <tr>
                           <td valign="middle">
                              <?php if (get_field('logo_image', 'options')) {
                                 ?>
                              <img width="130px" src="<?php echo str_replace(' ', '%20',get_field('logo_image', 'options')); ?>"/>
                              <?php
                                 } ?>
                           </td>
                           <td  width="70%" class="logo_text" valign="middle" style="color:#016cb4; padding-top:5px; padding-left:20px; font-size:12px;"">
                           <span style="display:inline-block; vertical-align:middle; border-left:solid 2px #016cb4; padding-left:15px; padding-top:10px;">American Engineering Trusted Wordwide <sup style="display:inline-block;">®</sup></span>
                          </td>
                        </tr>
                     </table>
                  </td>
                  <td width="20%" style="text-align: right;padding:10px 40px 10px 20px;">
                     <h3 style="margin: 0px;padding: 0px;">DATA SHEET</h3>
                     <p style="font-size:12px;padding: 5px 0 0 0;margin: 0px;line-height: 12px;"><?php the_field('part_number');?>
                        <br><?php date_default_timezone_set('America/New_York'); echo date('m/d/Y g:i A'); ?>
                     </p>
                  </td>
               </tr>
            </table>
         </header>
      </div>
      <footer>
         <table cellspacing="0" cellpadding="0" border="0" width="100%">
            <tr bgcolor="#0f6db5">
               <td colspan="2" align="right" style="padding: 10px 30px;color:#FFF;">
                  <?php echo home_url(); ?> <?php echo get_field('phone_number', 'options'); ?>
               </td>
            </tr>
            <tr>
               <td colspan="2" style="padding: 10px 30px;">
                  <?php if (get_field('pdf_footer_text', 'options')) {
        ?>
                  <p style="margin: 0px;padding: 0px;font-size:9px;color: #444;line-height: 8px;">
                     <?php echo get_field('pdf_footer_text', 'options'); ?>
                  </p>
                  <?php
    }?>
               </td>
            </tr>
         </table>
      </footer>
      <div class="main-content-pdf">
         <table cellspacing="0" cellpadding="0" border="0" width="100%">
            <tr>
               <td width="100%" style="vertical-align: top;padding-top: 15px">
                  <table width="100%">
                     <?php if (get_field('part_number')) {
                        ?> 
                     <tr>
                        <th align="left">Product Category</th>
                        <td align="right"><?php the_field('part_number'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('product_line')) {
                        ?> 
                     <tr>
                        <th align="left">Product Line</th>
                        <td align="right"><?php the_field('product_line'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('part_description')) {
                        ?> 
                     <tr>
                        <th align="left">Part Description</th>
                        <td align="right"><?php the_field('part_description'); ?></span></td>
                     </tr>
                     <?php
                        } ?>
					
                  </table>
               </td>
            </tr>
            <tr>
            <td width="100%" align="center">
                  <?php if (get_the_post_thumbnail_url()) {
                     ?>
                  <img width="220px" src="<?php echo str_replace(' ', '%20',get_the_post_thumbnail_url(get_the_ID(),'full')); ?>"/>
                  <?php
                     }else if($product_category['0']->term_taxonomy_id=='8'){?>
                        <img width="220px" src="<?php echo str_replace(' ', '%20',get_field('pdf_product_image', 'options')); ?>"/>
                     <?php }else{
                         ?>
                         <img width="220px" src="<?php echo str_replace(' ', '%20',get_field('pdf_product_image_fittings', 'options')); ?>"/>
                     <?php
                     } ?>
               </td>
            </tr>
            <tr>
               <td colspan="2">
                  <h2 style="margin: 0px 0 10px 0;padding: 0px;color: #0f6db5;font-size: 17px;">DIMENSIONS</h2>
                  <table class="table_list table8" cellpadding="0" cellspacing="0" border="0" style="width: 100%;border:1px solid #CCC;margin-bottom: 30px;">
                     <tbody>
                        <?php if (get_field('port_dia')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Port Dia.</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('port_dia'); ?></td>
                        </tr>
                        <?php
                           }?>
                     <tbody>
                        <?php if (get_field('orifice')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Orifice</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('orifice'),3,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('a')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">A</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('a'),3,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('a-single')) {
                        ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">A'</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('a-single'),3,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('a-double')) {
                        ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">A"</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('a-double'),3,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('a-npt')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">A-NPT : </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('a-npt'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('a_nps')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">A (NPS) </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('a_nps'),3,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('b')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">B</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('b'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('b-value')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">B' </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('b-value'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('b-thread')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">B-THREAD </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('b-thread'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('b-npt')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">B-NPT </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('b-npt'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('b-hex')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">B-HEX </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('b-hex'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('c')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">C </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('c'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('c_open')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">C (Open)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('c_open'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('c_closed')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">C (Closed)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('c_closed'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('crn')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">CRN </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('crn'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('c-thread')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">C-THREAD </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('c-thread'); ?></td>
                        </tr>
                        <?php
                           }?>
                           <?php if (get_field('c-hex')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">C-HEX </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('c-hex'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('d')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">D </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('d'),3,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                           <?php if (get_field('d-single')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">D'</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('d-single'),3,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                           <?php if (get_field('d-double')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">D" </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('d-double'),3,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('d-thread')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">D-THREAD </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('d-thread'); ?></td>
                        </tr>
                        <?php
                           }?>
                           <?php if (get_field('d-hex')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">D-HEX </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('d-hex'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('e')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">E</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('e'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('f')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">F </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('f'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('f_pipe_size')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">F (Pipe Size)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('f_pipe_size'),3,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('f_tube_size')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">F (Tube Size)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('f_tube_size'),3,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('f-thread')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">F-THREAD </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('f-thread'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('f_normally_open')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">F (Normally Open)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('f_normally_open'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('f_normally_closed')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">F (Normally Closed)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('f_normally_closed'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('lift')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Lift</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('lift'); ?></td>
                        </tr>
                        <?php
                           }?>
                   
                        <?php if (get_field('g')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">G</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('g'); ?></td>
                        </tr>
                        <?php
                           }?>
                           <?php if (get_field('g-hex')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">G-HEX</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('g-hex'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('h')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">H</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('h'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('j-hex')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">J-HEX</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('j-hex'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('j_max')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">J (max.)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('j_max'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('j_normally_open')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">J (Normally Open)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('j_normally_open'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('j_normally_closed')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">J (Normally Closed)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('j_normally_closed'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('k')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">K </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('k'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('face_to_face')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Face to Face </th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('face_to_face'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('dia_of_bolt_circle')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Dia. of Bolt Circle</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('dia_of_bolt_circle'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('dia_of_flange')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Dia. of Flange</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('dia_of_flange'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('no_of_studs')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">No. of Studs</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('no_of_studs'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('dia_of_studs')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Dia. of Studs</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('dia_of_studs'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('length_of_studs')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Length of Studs</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php echo number_format(get_field('length_of_studs'),2,'.',''); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('thickness_of_flange')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Thickness of Flange</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('thickness_of_flange'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('end_to_end')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">End to End</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('end_to_end'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('overall_length')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Overall Length</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('overall_length'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('female_inlet_and_outlet_npt')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Female Inlet and Outlet (NPT)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('female_inlet_and_outlet_npt'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('center_of_outlet_to_bottom')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Center of Outlet to Bottom</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('center_of_outlet_to_bottom'); ?></td>
                        </tr>
                        <?php
                           }?>
                        <?php if (get_field('weight_lbs')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Weight (lbs.)</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('weight_lbs'); ?></td>
                        </tr>
                        <?php
                           }?>
                           <?php if (get_field('panel_bore_dia')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">PANEL BORE DIA.</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('panel_bore_dia'); ?></td>
                        </tr>
                        <?php
                           }?>
                           <?php if (get_field('union_nut_size')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Union Nut Size</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('union_nut_size'); ?></td>
                        </tr>
                        <?php
                           }?>
                           <?php if (get_field('mark_viii_dash')) {
                           ?>
                        <tr>
                           <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Mark VIII Dash</th>
                           <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('mark_viii_dash'); ?></td>
                        </tr>
                        <?php
                           }?>
                     </tbody>
                  </table>
               </td>
            </tr>
            <?php if (get_field('pressure_rating') || get_field('temperature_range') || get_field('standard_soft_goods') || get_field('cartridge_type') || get_field('connection_type') || get_field('connection_size') || get_field('tube_od') || get_field('body_material') || get_field('fitting_material') || get_field('bonnet_material') || get_field('crn') || get_field('approved_per')) {
               ?>
            <tr>
               <td colspan="2">
                  <h2 style="margin: 0px 0 10px 0;padding: 0px;color: #0f6db5;font-size: 17px;">GENERAL</h2>
                  <table class="table8" cellspacing="0" cellpadding="0" border="0" style="width: 100%;border:1px solid #CCC;margin-bottom: 30px;">
                     <?php if (get_field('pressure_rating')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Pressure Rating</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('pressure_rating'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('temperature_range')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Temperature Range</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('temperature_range'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('standard_soft_goods')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Standard Soft Goods</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('standard_soft_goods'); ?></td>
                        </td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('cartridge_type')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Cartridge Type</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('cartridge_type'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('connection_type')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Connection Type</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('connection_type'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('connection_size')) {
                        ?>
                     <tr >
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Connection Size</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('connection_size'); ?></td>
                        </td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('tube_od')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Tube O.D. </th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('tube_od'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('body_material')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Body Material</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('body_material'); ?></td>
                     </tr>
                     <?php
                        } ?>

                    <?php if (get_field('bonnet_material')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Bonnet Material</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('bonnet_material'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('assembly_material')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Assembly Material</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('assembly_material'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('tailpiece_material')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Tailpiece Material</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('tailpiece_material'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('threadpiece_material')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Threadpiece Material</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('threadpiece_material'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('union_nut_material')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Union Nut Material</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('union_nut_material'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('o-ring_material')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">O-Ring Material</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('o-ring_material'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('fitting_material')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Fitting Material</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('fitting_material'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('connection_1_type')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Connection 1 Type</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('connection_1_type'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('connection_1_size')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Connection 1 Size</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('connection_1_size'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('connection_2_type')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Connection 2 Type</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('connection_2_type'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('connection_2_size')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Connection 2 Size</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('connection_2_size'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('connection_3_type')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Connection 3 Type</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('connection_3_type'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('connection_3_size')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Connection 3 Size</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('connection_3_size'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('connection_4_type')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Connection 4 Type</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('connection_4_type'); ?></td>
                     </tr>
                     <?php
                        } ?>
                        <?php if (get_field('connection_4_size')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Connection 4 Size</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('connection_4_size'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('crn')) {
                        ?>
                     <tr >
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">CRN</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('crn'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('approved_per')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Approved per</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('approved_per'); ?></td>
                     </tr>
                     <?php
                        } ?>
                  </table>
               </td>
            </tr>
            <?php
               } ?>
            <?php if (get_field('vc__vacuum_service') || get_field('p__panel_mount') || get_field('port_&_vent_options') || get_field('optional_soft_goods')) {
               ?>
            <tr>
               <td colspan="2">
                  <h2 style="margin: 0px 0 10px 0;padding: 0px;color: #0f6db5;font-size: 17px;">OPTIONS</h2>
                  <table class="table8" cellspacing="0" cellpadding="0" border="0" style="width: 100%;border:1px solid #CCC;margin-bottom: 30px;">
                     <?php if (get_field('vc__vacuum_service')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">[-VC] Vacuum Service</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('vc__vacuum_service'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('p__panel_mount')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">[-P] Panel Mount</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('p__panel_mount'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('port_&_vent_options')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Port & Vent Options</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('port_&_vent_options'); ?></td>
                     </tr>
                     <?php
                        } ?>
                     <?php if (get_field('optional_soft_goods')) {
                        ?>
                     <tr>
                        <th style="font-size: 12px;padding: 5px 7px; color: #000;text-align: left;">Optional Soft Goods</th>
                        <td style="color: #444;padding: 5px 7px;" align="right"><?php the_field('optional_soft_goods'); ?></td>
                     </tr>
                     <?php
                        } ?>
                  </table>
               </td>
            </tr>
            <?php
               } ?>
         </table>
      </div>
      <?php wp_footer();?>
   </body>
</html>
