<!DOCTYPE html>
<html>
<head>
    @section('head')
        <meta charset="{{bloginfo( 'charset' )}}">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no"/>
        <link rel="profile" href="https://gmpg.org/xfn/11">
        <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800%7cRoboto+Condensed:300,400,700%7cRoboto:100,300,400,500,700" rel="stylesheet">
		<link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Teko:wght@300;400;500;600;700&display=swap" rel="stylesheet">
        {!! wp_head() !!}
        <link rel="stylesheet" href="{{mix('main.css')}}?ver=<?php echo rand(); ?>">
        <link rel="stylesheet" href="{{public_path('/style-n.css')}}">
    @show
	<!-- Google Tag Manager -->
	<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
		new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
		j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
		'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
		})(window,document,'script','dataLayer','GTM-W5QRVG5');</script>
	</script>
	<!-- End Google Tag Manager -->

    <style type="text/css">
    .rmvOp{
        opacity: unset !important;
    }    

    </style>
    <script src="https://unpkg.com/masonry-layout@4/dist/masonry.pkgd.js"></script>
</head>
<body {{body_class()}}>
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-W5QRVG5"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="wrapper">
    @section('header')
        @include('views.partials.header')
    @show

    @yield('pre-content')

    @section('the-loop')
        @if (have_posts())
            @yield('content')
        @else
            @yield('no-content')
        @endif
    @show

    @yield('post-content')

    @section('footer')
        @include('views.partials.footer')
    @show

    @section('scripts')
        {!! wp_footer() !!}
        
        <script src="{{mix('main.js')}}?ver=<?php echo rand(); ?>"></script>
        <script>
            count = 0;
            wordsArray = ["{{ get_field('solagn', 'options') }}", "{{ get_field('solagn1', 'options') }}"];
            setInterval(function () {
                count++;
                jQuery(".solagn").fadeOut(400, function () {
                jQuery(this).text(wordsArray[count % wordsArray.length]).fadeIn(100);
                });
            }, 5000);
        </script>
        <script>
            jQuery('#filter_news').submit(function () {
            var filter = jQuery('#filter_news');
                jQuery.ajax({
                    url: filter.attr('action'),
                    data: filter.serialize(), // form data
                    type: filter.attr('method'), // POST
                    success: function (data) {
                        jQuery('.news-content').html(data);
                        jQuery.getScript("{{home_url()}}/app/plugins/ajax-load-more/core/dist/js/ajax-load-more.min.js", function() {});
                    }
                });
                return false;
            });
        </script>
          <script>
        function deletesearch(id){
			var check = confirm("Are you sure you want to delete?");
			if (check == true) {
				  var data = {
                'action': 'delete_search',
                'id': id
				};
				jQuery.ajax({
					url: '{{home_url()}}/wp/wp-admin/admin-ajax.php',
					data: data, // form data
					type: 'POST', // POST
				    success: function (data) {
						window.location.replace("{{home_url()}}/my-account/?delete=1");
						//window.location.assign("https://cpv.stage.demotesturl.net/my-account/?delete=1");
                        jQuery('.top_alert .container .alert').html("<b>Alert</b> : Product deleted successfully.");						
                    }
				});
				return true;
			}
			else {
				return false;
			}       
        }
        </script>
        <?php if (isset($_GET['search'])) {
    ?>
        <script>
            jQuery('select').prop('disabled', false);
            jQuery.ajax({
            url : '{{home_url()}}/wp/wp-admin/admin-ajax.php',
            type : 'post',
            dataType: 'json',
            data : {
                action : 'view_product',
                id: {{ $_GET['search']}}
            },
            success : function( response ) {
                jQuery.each(response, function(key, value) {
                    jQuery('.'+key).val(value).trigger('change');
                });
                jQuery('.filter_search').click();
            }
        });
        </script>
        <?php
}
if (isset($_GET['s'])) 
{ ?>
<script>
jQuery('.search-slide').addClass('open_search_form');
 setTimeout(function() { jQuery('.search-area__form-control').focus() }, 3000);
</script>
<?php } ?>
    @show
</div>
</body>

</html>
