@extends('views.layouts.main')

@section('content')
@while (have_posts()) @php the_post() @endphp
@php $path= parse_url($_SERVER['REQUEST_URI']);
$path = explode("/",$path['path']);
$type= $path[1];
@endphp
<main class="main">
    <div class="technial-section">
        <div class="container">
        <div class="breadcrumb">{{bcn_display()}}</div>
            <div class="technial-heading">
                <h1 class="technial-heading__heading02">{{get_the_title(null, null, false)}}</h1>
                <p class="technial-heading__text02"> {!!the_content()!!}</p>
            </div>
        </div>
    </div>
    <?php 
    $member_group_terms = get_terms( 'resource-category' );
    foreach ( $member_group_terms as $member_group_term ) {
        $member_group_query = new WP_Query( array(
            'post_type' => 'technicalresources',
            'post_status' => 'publish',
            'tax_query' => array(
                'relation' => 'AND',
                array(
                    'taxonomy' => 'type',
                    'field'    => 'slug',
                    'terms'    => $type,
                ),
                array(
                    'taxonomy' => 'resource-category',
                    'field' => 'slug',
                    'terms' => array( $member_group_term->slug ),
                    'operator' => 'IN'
                )
            )
        ) );
        ?>    
        <?php
        if ( $member_group_query->have_posts() ) : 
         ?>  
         <div class="technial-section">
         <div class="container">
             <div class="technial-heading">
             <h2 class="technial-heading__heading02"> {!! $member_group_term->name !!}</h2>
             <p class="technial-heading__text02"> {!! $member_group_term->description !!}</p>
        </div>
        <div class="technial-block-holder">
        <?php while ( $member_group_query->have_posts() ) : $member_group_query->the_post(); ?>
            <div class="technial-block">
                <div class="technial-block__image-holder">
                @if(get_the_post_thumbnail_url())
                <a href="{{get_permalink()}}" class="history-block__link">{{the_post_thumbnail('full', array('class' => 'technial-block__img'))}}</a>
                @endif
                </div>
                <div class="technial-description">
                    @if(get_the_title())
                    <strong class="technial-description__title02"><a href="{{get_permalink()}}" class="technial-description__link02">{!!the_title()!!}</a></strong>
                    @endif
                    @if(get_the_excerpt())
                    <p class="mb-0">{!!the_excerpt()!!}</p>
                    @endif
                </div>
            </div>
        <?php endwhile; ?>
        </div>
        </div>
        <?php endif;
        // Reset things, for good measure
        $member_group_query = null;
        wp_reset_postdata();
    }
    ?>
  
</main>

@endwhile
@endsection
