@extends('views.layouts.main')

@section('content')
<form id="filter" action="<?php bloginfo('url'); ?>" method="post">
<?php 
// Set your custom taxonomy
$taxonomy = "productcategory";
// Factored out taxonomy dropdown into function my_dropdown_categories() in "functions.php".
echo my_dropdown_categories( $taxonomy );
?>

<div class="container_2">
    <div class="card-header" data-toggle="collapse" href="#collapse2">
        <a class="card-title">Type</a>
    </div>
    <div id="collapse2" class="card-body collapse show" data-parent="#accordion" >
        {{ get_select_taxo_field('valvetype')}}
    </div>
</div>
<div class="container_3">
    <div class="card-header collapsed" data-toggle="collapse" href="#collapse3">
        <a class="card-title">{{get_field_object('field_5ab203bebaf19')['label']}}</a>
    </div>
    <div id="collapse3" class="card-body collapse" data-parent="#accordion" >
        {{ get_select_custom_field('field_5ab203bebaf19')}}
    </div>
</div>
<div class="container_4">
    <div class="card-header collapsed" data-toggle="collapse" href="#collapse4">
        <a class="card-title">{{get_field_object('field_5ab2043f5c31e')['label']}}</a>
    </div>
    <div id="collapse4" class="card-body collapse" data-parent="#accordion" >
        {{ get_select_custom_field('field_5ab2043f5c31e')}}
    </div>
</div>
<div class="container_5">
    <div class="card-header collapsed" data-toggle="collapse" href="#collapse5">
        <a class="card-title">{{get_field_object('field_5ab2044b5c31f')['label']}}</a>
    </div>
    <div id="collapse5" class="card-body collapse" data-parent="#accordion" >
        {{ get_select_custom_field('field_5ab2044b5c31f')}}
    </div>
</div>
<div class="container_6">
    <div class="card-header collapsed" data-toggle="collapse" href="#collapse6">
        <a class="card-title">{{get_field_object('field_5ab204525c320')['label']}}</a>
    </div>
    <div id="collapse6" class="card-body collapse" data-parent="#accordion" >
        {{ get_select_custom_field('field_5ab204525c320')}}
    </div>
</div>
<div class="container_7">
    <div class="card-header collapsed" data-toggle="collapse" href="#collapse7">
        <a class="card-title">{{get_field_object('field_5ab2045a5c321')['label']}}</a>
    </div>
    <div id="collapse7" class="card-body collapse" data-parent="#accordion" >
        {{ get_select_custom_field('field_5ab2045a5c321')}}
    </div>
</div>
<div class="submit-button-blanket"><button class="submit-button" type="submit">Search</button></div>
</form>
</div>
<script type="text/javascript">
jQuery(document).ready(function() {
    (function ($) {
        $('#filter select').change(function (event) {
            $.post( <?php echo json_encode( admin_url( 'admin-ajax.php' ) ); ?>, {
                    action: 'get_terms_for_cpt',
                    post_type: 'products',
                    taxonomy: <?php echo json_encode( $taxonomy ); ?>,
                    current_selected: $("#filter :input[value!='']").serialize(),
                    nonce: <?php echo json_encode( wp_create_nonce( 'wpse158929_get_terms_for_cpt_submit_' ) ); ?>
                }, function( response ) {
                    if ( response && !response.error ) {
                        $('select[name="productcategory"]').html(response.html);
                    }
                }, 'json'
            );
        });
        // Remove if you don't want to call change immediately.
        $('select[name="post_type"]').change();
    })(jQuery);
});
</script>

@endsection