<?php 
        $args = array('orderby' => 'name', 'order' => 'ASC', 'fields' => 'all');
        $categories = wp_get_post_terms(get_the_ID(), 'news-category', $args);
        if (!empty($categories)) {
            $all_categories=array();
            foreach ($categories as $category) {
                $all_categories[]=$category->slug;
            }
        }
        
        ?>
<div class="news-block <?php if(isset($all_categories)){
    echo implode(" ", $all_categories);
}?>">
    <div class="news-block__image-holder">
        <a href="<?php the_permalink(); ?>" class="news-block__image-link">
        <?php if (has_post_thumbnail()) {
    ?>
		<img style="width:100%;" class="news-block__img" src="<?php echo wp_get_attachment_url(get_post_thumbnail_id(get_the_id())); ?>" alt="<?php the_title(); ?>"></a>
		<?php
} ?>
		
    </div>
    <div class="news-description">
        <time class="news-description__time"><?php the_time("F d, Y"); ?></time>
        <h3 class="news-description__heading"><a href="<?php the_permalink(); ?>" class="news-description__link"><?php the_title(); ?></a></h3>
        <p class="news-description__text"><?php the_excerpt(); ?></p>
        <b><?php 
        $args = array('orderby' => 'name', 'order' => 'ASC', 'fields' => 'all');
        $tags = wp_get_post_terms(get_the_ID(), 'tag', $args);
        if (!empty($tags)) {
            $all_tags=array();
            foreach ($tags as $tag) {
                $all_tags[]=$tag->name;
            }
            echo implode(", ", $all_tags);
        }
        
        ?></b>
    </div>
</div>